//------------------------------------------------------------------------------
// File: svr_savealerts.cs
// This file is used to save and load the asserts on the server.  The functions
// here are synched with the client-side alert saving and loading functions.
//
// Copyright Sandlot Games, 2007
// Author: Michael Felice
//------------------------------------------------------------------------------

// this function is called when the alerts need to be saved (note
// that this needs to be synched, so no saving should occur directly
// after this function is called (wait for serverCmdAlertSaveFromFileDone)
function AlertSaveToFile()
{
   // save all of the alerts
   for(%alert = 0; %alert < $ALERT_COUNT; %alert++)
   {
      %count = alertSvrGetAlertLocationCount(%alert);
      slgSaveInt(%count);

      for(%index = 0; %index < %count; %index++)
      {
         %data = alertSvrGetAlertLocation(%alert, %index);
         
         // save the tornado alert
         if (%alert == $ALERT_TORNADO)
         {
            %disasterIndex = slgGetDisasterIndex(%data);
            slgSaveInt(%disasterIndex);
         }
         
         // save the rest of the alerts
         else
         {
            %saveID = %data.getSaveID();
            slgSaveInt(%saveID);
         }
      }
   }
   
   %client = ClientGroup.getObject(0);
   commandToClient(%client, 'AlertSaveToFile');
   
   return true;
}

// this function is called from the client when the client is done
// saving the alerts (continues the save process on the server)
function serverCmdAlertSaveToFileDone(%client)
{
   slgSaveString($QuitScenarioCallback);
   slgSaveBool($DisableQuitScenario);
   slgSaveBool($DisableReloadScenario);
   
   $DoneLoading = true;
}



// this function is called when the alerts need to be loaded (note
// that this needs to be synched, so no loading should occur directly
// after this function is called (wait for serverCmdAlertLoadFromFileDone)
function AlertLoadFromFile()
{
   alertSvrClearDatabase();
   
   // load all of the alerts
   for(%alert = 0; %alert < $ALERT_COUNT; %alert++)
   {
      %count = slgLoadInt();
      for(%index = 0; %index < %count; %index++)
      {
         // load the tornado alert
         if (%alert == $ALERT_TORNADO)
         {
            %disasterIndex = slgLoadInt();
            %disaster = slgGetDisasterID(%disasterIndex);
            %data = %disaster;
         }
         // load the rest of the alerts
         else
         {
            %saveID = slgLoadInt();
            %object = slgGetGameObject(%saveID);
            %data = %object;
         }
         alertSvrAddAlertLocation(%alert, %data);
      }
   }
   
   %client = ClientGroup.getObject(0);
   commandToClient(%client, 'AlertLoadFromFile');
}

// this function is called from the client when the client is done
// loading the alerts (continues the load process on the server)
function serverCmdAlertLoadFromFileDone(%client)
{
   // only load the quit scenario information if forcefully
   // loading a game, not quitting from a main game
   if ($LoadCarryBackData == true)
   {
      $QuitScenarioCallback = slgLoadString();
   }
   else
   {
      slgLoadString();
   }
   
   $DisableQuitScenario = slgLoadBool();
   $DisableReloadScenario = slgLoadBool();
   
   $LoadResources = false;
   $DoneLoading = true;
   StopWaiting();
}
